<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-02-04 15:18
 */
interface AvailableparcodeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Availableparcode 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param availableparcode primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Availableparcode availableparcode
 	 */
	public function insert($availableparcode);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Availableparcode availableparcode
 	 */
	public function update($availableparcode);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByValue($value);


	public function deleteByValue($value);


}
?>